/* $Header: TestNDM2Jena2.java 02-dec-2004.07:12:19 nalexand Exp $ */

/* Copyright (c) 2004, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    <short description of component this file declares/defines>

   PRIVATE CLASSES
    <list of private classes defined - with one-line descriptions>

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    nalexand    12/02/04 - testing containers and collections 
    nalexand    11/23/04 - testing typed literals and listing output 
    nalexand    11/20/04 - nalexand_rdfjena1711
    nalexand    11/19/04 - Creation
 */

/**
 *  @version $Header: TestNDM2Jena2.java 02-dec-2004.07:12:19 nalexand Exp $
 *  @author  nalexand
 *  @since   release specific (what release of product did this appear in)
 */

package oracle.spatial.rdf;
 
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelFactory;

public class TestNDM2Jena2 
{
  public TestNDM2Jena2()
  {
  }
  protected static OracleConnection m_conn;
  static
  { 
  // database connection for testing using scott/tiger
      OracleConnection conn = null;
      try { 
          DriverManager.registerDriver(new OracleDriver()) ;
          conn = (OracleConnection)DriverManager.getConnection("jdbc:oracle:thin:@stadb60.us.oracle.com:15210:rdf","scott","tiger"); } 
          catch(SQLException e) { e.printStackTrace();}
          m_conn = conn;
  }
    
  /**
   * 
   * @param args
   */
  public static void main(String[] args)throws SQLException, IOException, ClassNotFoundException
  {
    
    String className = "oracle.jdbc.driver.OracleDriver";   // path of driver class 
    Class.forName (className);                      // load driver 
    String DB_URL = "jdbc:oracle:thin:@stadb60.us.oracle.com:15210:rdf";       // URL of database server 
    String DB_USER = "scott";                        // database user id 
    String DB_PASSWD = "tiger";                          // database password 
    String DB = "Oracle";                            // database type 
  
  // Create database connection 
  IDBConnection m_jconn = new DBConnection ( DB_URL, DB_USER, DB_PASSWD, DB ); 
    
    
    
        try{
          String modelName = args [0];
          int modelID = Integer.parseInt(args[1]);
          
          ModelMaker maker = ModelFactory.createModelRDBMaker(m_jconn);
          Model m = maker.createModel(modelName);
          //removes data from model if it alreay exists -- it does not remove the tables
          m.remove(m);
          
          Jena2Converter.setOracleConnection(m_conn);
          Jena2Converter.setJenaDBConnection(m_jconn);
          
          Jena2Converter.convertJena2(modelName,modelID);
    
        }catch (Exception e) {e.printStackTrace();}
  }
}
